/*
 * Decompiled with CFR 0.152.
 */
package usn.net.ssl.util;

import java.security.Security;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.net.ssl.SSLHandshakeException;
import usn.net.ssl.util.SavingSSLSocketFactory;
import usn.net.ssl.util.StarttlsHandler;

class StarttlsHandlerSMTP
implements StarttlsHandler {
    StarttlsHandlerSMTP() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(String host, int port) {
        System.out.println("... trying SMTP with STARTTLS extension ...");
        Properties mailProps = new Properties();
        mailProps.put("mail.transport.protocol", "smtp");
        mailProps.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        mailProps.put("mail.smtp.socketFactory.fallback", "false");
        mailProps.put("mail.smtp.starttls.enable", "true");
        Security.setProperty("ssl.SocketFactory.provider", SavingSSLSocketFactory.class.getName());
        Session mailSession = Session.getDefaultInstance((Properties)mailProps);
        Transport tr = null;
        try {
            tr = mailSession.getTransport();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            return false;
        }
        try {
            tr.connect(host, port, null, null);
        }
        catch (MessagingException e) {
            if (e.getNextException() instanceof SSLHandshakeException) {
                System.out.println("ERROR on SSL handshake: " + e.toString());
                boolean bl = true;
                return bl;
            }
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (tr.isConnected()) {
                try {
                    tr.close();
                }
                catch (MessagingException e) {}
            }
        }
        return false;
    }
}

