/*
 * Decompiled with CFR 0.152.
 */
package usn.net.ssl.util;

import java.io.IOException;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLHandshakeException;
import usn.net.ssl.util.InstallCert;
import usn.net.ssl.util.SavingSSLSocketFactory;
import usn.net.ssl.util.StarttlsHandler;

class StarttlsHandlerLDAP
implements StarttlsHandler {
    StarttlsHandlerLDAP() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(String host, int port) {
        System.out.println("... trying LDAP with STARTTLS extension ...");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("com.sun.jndi.ldap.connect.timeout", "5000");
        env.put("com.sun.jndi.ldap.read.timeout", "5000");
        env.put("java.naming.provider.url", "ldap://" + host + ":" + port + "/");
        InitialLdapContext ctx = null;
        StartTlsResponse tls = null;
        try {
            try {
                ctx = new InitialLdapContext(env, null);
                tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
            }
            catch (NamingException e) {
                InstallCert.terminateWithErrorMessage(e, "creating the STARTTLS handler object");
            }
            try {
                tls.negotiate(new SavingSSLSocketFactory());
            }
            catch (SSLHandshakeException e) {
                System.out.println("ERROR on IMAP authentication: " + e.toString());
                boolean bl = true;
                try {
                    tls.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                try {
                    ctx.close();
                }
                catch (NamingException e3) {
                    e3.printStackTrace();
                }
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        finally {
            try {
                tls.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                ctx.close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

