/*
 * Decompiled with CFR 0.152.
 */
package usn.net.ssl.util;

import java.security.Security;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import usn.net.ssl.util.SavingSSLSocketFactory;
import usn.net.ssl.util.StarttlsHandler;

class StarttlsHandlerIMAP
implements StarttlsHandler {
    StarttlsHandlerIMAP() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(String host, int port) {
        System.out.println("... trying IMAP with STARTTLS extension ...");
        Properties mailProps = new Properties();
        mailProps.put("mail.store.protocol", "imap");
        mailProps.put("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        mailProps.put("mail.imap.socketFactory.fallback", "false");
        mailProps.put("mail.imap.starttls.enable", "true");
        Security.setProperty("ssl.SocketFactory.provider", SavingSSLSocketFactory.class.getName());
        Session mailSession = Session.getDefaultInstance((Properties)mailProps);
        Store store = null;
        try {
            store = mailSession.getStore("imap");
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            return false;
        }
        try {
            store.connect(host, port, "", "");
        }
        catch (AuthenticationFailedException e) {
            System.out.println("ERROR on IMAP authentication: " + e.toString());
            boolean bl = true;
            return bl;
        }
        catch (MessagingException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (store.isConnected()) {
                try {
                    store.close();
                }
                catch (MessagingException e) {}
            }
        }
        return false;
    }
}

