/*
 * Decompiled with CFR 0.152.
 */
package usn.net.ssl.util;

import java.io.IOException;
import usn.net.ssl.util.InstallCert;
import usn.net.ssl.util.StarttlsHandler;

class Starttls {
    Starttls() {
    }

    static boolean consider(String host, int port) throws IOException {
        String userResponse;
        Protocol protocolForPort = Protocol.getByPort(port);
        if (protocolForPort != null) {
            return Starttls.obtainProtocolHandlerAndRun(protocolForPort.name(), host, port);
        }
        StringBuilder prompt = new StringBuilder("Try STARTTLS with one of these protocols?\n");
        for (Protocol p : Protocol.values()) {
            prompt.append(p.name());
            prompt.append(": ");
            prompt.append(p.ordinal() + 1);
            prompt.append("\n");
        }
        prompt.append("none: <Enter> : ");
        while ((userResponse = InstallCert.ask(prompt.toString())).length() > 0) {
            int itemNr;
            try {
                itemNr = Integer.parseInt(userResponse);
            }
            catch (NumberFormatException e) {
                System.out.println("... invalid response.");
                continue;
            }
            Protocol protocol = Protocol.values()[itemNr - 1];
            if (protocol != null) {
                return Starttls.obtainProtocolHandlerAndRun(protocol.name(), host, port);
            }
            System.out.println("... invalid response.");
        }
        System.out.println("... no more ideas, program terminated.");
        return false;
    }

    static boolean obtainProtocolHandlerAndRun(String handlerSuffix, String host, int port) {
        Class<?> handlerClass = null;
        try {
            Class<?> handlerUncheckedClass;
            handlerClass = handlerUncheckedClass = Class.forName(StarttlsHandler.class.getName() + handlerSuffix);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoClassDefFoundError e) {
            if (e.getCause().getClass().equals(ClassNotFoundException.class) && e.getCause().getMessage().equals("javax.mail.NoSuchProviderException")) {
                System.out.println("ERROR loading protocol-specific STARTTLS handler: " + e.toString());
                System.out.println("Looks like you need to make JavaMail library available on your classpath, something like this:\n  java -cp " + System.getProperty("java.class.path") + System.getProperty("path.separator") + "..." + System.getProperty("file.separator") + "javax.mail.jar " + "usn.net.ssl.util.InstallCert " + InstallCert.joinStringArray(InstallCert.savedArgs, " "));
                System.exit(1);
            }
            e.printStackTrace();
            System.exit(1);
        }
        StarttlsHandler handler = null;
        try {
            handler = (StarttlsHandler)handlerClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
        return handler.run(host, port);
    }

    static enum Protocol {
        SMTP(25),
        POP3(110),
        IMAP(143),
        LDAP(389);

        int port;

        private Protocol(int port) {
            this.port = port;
        }

        public static Protocol getByPort(int port) {
            for (Protocol p : Protocol.values()) {
                if (p.port != port) continue;
                return p;
            }
            return null;
        }
    }
}

