/*
 * Decompiled with CFR 0.152.
 */
package usn.net.ssl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import sun.security.provider.certpath.SunCertPathBuilderException;
import sun.security.validator.ValidatorException;
import usn.net.ssl.util.Starttls;

public class InstallCert {
    static final String PROGRAM_TERMINATED = "Program terminated.";
    static final String EXTRA_CERTS_FILE_NAME = "extracerts";
    static SSLContext context;
    static String[] savedArgs;

    private InstallCert() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        savedArgs = args;
        Vector<String> argsCopy = new Vector<String>(Arrays.asList(args));
        String host = null;
        int port = 0;
        char[] password = null;
        if (argsCopy.size() < 1) {
            InstallCert.terminateWithUsageMessage();
        }
        if (argsCopy.size() > 2) {
            InstallCert.terminateWithUsageMessage();
        }
        String[] c = argsCopy.get(0).split(":");
        host = c[0];
        port = c.length < 2 ? 443 : Integer.parseInt(c[1]);
        String p = argsCopy.size() < 2 ? "changeit" : argsCopy.get(1);
        password = p.toCharArray();
        KeyStore ksKnown = KeyStore.getInstance(KeyStore.getDefaultType());
        char SEP = File.separatorChar;
        File systemSecurityDir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
        File file = new File(systemSecurityDir, "jssecacerts");
        if (!file.exists()) {
            file = new File(systemSecurityDir, "cacerts");
        }
        System.out.println("... loading system truststore from '" + file.getCanonicalPath() + "' ...");
        FileInputStream in = new FileInputStream(file);
        ksKnown.load(in, password);
        ((InputStream)in).close();
        KeyStore ksNew = KeyStore.getInstance(KeyStore.getDefaultType());
        file = new File(EXTRA_CERTS_FILE_NAME);
        if (file.exists()) {
            System.out.println("... loading extra truststore from '" + file.getCanonicalPath() + "' ...");
            in = new FileInputStream(file);
            ksNew.load(in, password);
            ((InputStream)in).close();
        } else {
            System.out.println("... creating extra truststore as a new one ...");
            ksNew.load(null, password);
        }
        context = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ksKnown);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager, ksNew);
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        System.out.println("... opening connection to " + host + ":" + port + " ...");
        SSLSocket sslSocket = null;
        try {
            sslSocket = (SSLSocket)factory.createSocket(host, port);
        }
        catch (ConnectException e) {
            InstallCert.terminateWithErrorMessage(e, "connecting to remote host");
        }
        sslSocket.setSoTimeout(10000);
        System.out.println("... starting SSL handshake ...");
        try {
            sslSocket.startHandshake();
            System.out.println("No errors, certificate is already trusted.");
        }
        catch (SSLHandshakeException e) {
            if (e.getCause().getClass().equals(ValidatorException.class) && e.getCause().getCause().getClass().equals(SunCertPathBuilderException.class)) {
                System.out.println(e.toString());
            } else if (e.getCause().getClass().getName().equals("java.io.EOFException")) {
                sslSocket.close();
                if (!Starttls.consider(host, port)) {
                    System.out.println(PROGRAM_TERMINATED);
                    System.exit(1);
                }
            } else {
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (SSLException e) {
            if (e.getMessage().equals("Unrecognized SSL message, plaintext connection?")) {
                System.out.println("ERROR on SSL handshake: " + e.toString());
                sslSocket.close();
                if (!Starttls.consider(host, port)) {
                    System.out.println(PROGRAM_TERMINATED);
                    System.exit(1);
                }
            } else {
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (SocketException e) {
            if (e.getMessage().equals("Connection reset")) {
                System.out.println("ERROR on SSL handshake: " + e.toString());
                sslSocket.close();
                if (!Starttls.consider(host, port)) {
                    System.out.println(PROGRAM_TERMINATED);
                    System.exit(1);
                }
            } else {
                e.printStackTrace();
                System.exit(1);
            }
        }
        finally {
            if (!sslSocket.isClosed()) {
                sslSocket.close();
            }
        }
        X509Certificate[] chain = tm.newCerts.toArray(new X509Certificate[0]);
        HashSet<X509Certificate> certsToSave = new HashSet<X509Certificate>();
        if (chain.length > 0) {
            System.out.println();
            System.out.println("Server sent " + chain.length + " certificate(s):");
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate cert = chain[i];
                System.out.println();
                System.out.println(" " + (i + 1) + " Subject " + cert.getSubjectDN());
                System.out.println("   Issuer  " + cert.getIssuerDN());
                System.out.println("   CN      " + InstallCert.getCommonName(cert));
                sha1.update(cert.getEncoded());
                System.out.println("   sha1    " + InstallCert.toHexString(sha1.digest()));
                md5.update(cert.getEncoded());
                System.out.println("   md5     " + InstallCert.toHexString(md5.digest()));
                System.out.println();
                if (ksKnown.getCertificateAlias(cert) != null) {
                    System.out.println("Certificate already known to the system truststore.");
                    continue;
                }
                if (ksNew.getCertificateAlias(cert) != null) {
                    System.out.println("Certificate already known to the extra truststore.");
                    continue;
                }
                String userResponse = InstallCert.ask("Add this certificate to the extra truststore [y/n] ? ");
                if (userResponse.length() > 0 && userResponse.substring(0, 1).toUpperCase(Locale.ENGLISH).equals("Y")) {
                    certsToSave.add(cert);
                    System.out.println("Certificate marked to be added.");
                    continue;
                }
                System.out.println("Certificate skipped.");
            }
        }
        if (!certsToSave.isEmpty()) {
            for (X509Certificate cert : certsToSave) {
                String alias = host + " - " + InstallCert.getCommonName(cert);
                ksNew.setCertificateEntry(alias, cert);
                ksKnown.setCertificateEntry(alias, cert);
                System.out.println();
                System.out.println(cert);
                System.out.println();
                System.out.println("Certificate will be added using alias '" + alias + "'.");
            }
            System.out.println();
            System.out.println("... adding certificate(s) to the extra truststore ...");
            FileOutputStream out = new FileOutputStream(EXTRA_CERTS_FILE_NAME);
            ksNew.store(out, password);
            ((OutputStream)out).close();
            System.out.println();
            System.out.println("New certificates saved to truststore 'extracerts' in the current directory.");
            File jssecacertsFile = new File(systemSecurityDir, "jssecacerts");
            out = new FileOutputStream(jssecacertsFile);
            ksKnown.store(out, password);
            ((OutputStream)out).close();
            System.out.println();
            System.out.println("New certificates also saved to system truststore '" + jssecacertsFile.getCanonicalPath() + "'.");
        } else {
            System.out.println();
            System.out.println("No new certificates found to be added to the extra truststore.");
        }
    }

    static void terminateWithUsageMessage() {
        System.out.println("Usage: java [-cp ." + System.getProperty("path.separator") + "javax.mail.jar] -jar installcert-usn-....jar <host>[:<port>] " + "[<truststore_password>]\n" + "Default port is 443.\n" + "Default truststore password is 'changeit'.");
        System.exit(1);
    }

    static void terminateWithErrorMessage(Throwable e, String context) {
        System.out.println("ERROR " + context + ": " + e.toString());
        System.out.println(PROGRAM_TERMINATED);
        System.exit(1);
    }

    static String joinStringArray(String[] array, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (String s : array) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (byte b : bytes) {
            sb.append(String.format("%02x ", b & 0xFF));
        }
        return sb.toString();
    }

    static String ask(String prompt) throws IOException {
        System.out.print(prompt);
        BufferedReader stdinReader = new BufferedReader(new InputStreamReader(System.in));
        String line = stdinReader.readLine().trim();
        return line;
    }

    static String getCommonName(X509Certificate cert) throws InvalidNameException {
        LdapName ldapDN = new LdapName(cert.getSubjectX500Principal().getName());
        String cn = "";
        for (Rdn rdn : ldapDN.getRdns()) {
            if (!rdn.getType().equals("CN")) continue;
            cn = rdn.getValue().toString();
        }
        return cn;
    }

    protected static class SavingTrustManager
    implements X509TrustManager {
        protected X509TrustManager parentTm;
        protected Set<X509Certificate> allAccumulatedCerts = new HashSet<X509Certificate>();
        protected Set<X509Certificate> newCerts = new HashSet<X509Certificate>();

        SavingTrustManager(X509TrustManager parentTm, KeyStore ksExtra) throws KeyStoreException {
            if (parentTm == null) {
                throw new IllegalArgumentException("Parent trust manager cannot be null.");
            }
            this.parentTm = parentTm;
            if (ksExtra != null) {
                Enumeration<String> ksAliases = ksExtra.aliases();
                while (ksAliases.hasMoreElements()) {
                    String alias = ksAliases.nextElement();
                    this.allAccumulatedCerts.add((X509Certificate)ksExtra.getCertificate(alias));
                }
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            CertificateException exceptionToRethrow;
            block4: {
                exceptionToRethrow = null;
                try {
                    this.parentTm.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    if (this.allAccumulatedCerts.contains(chain[0])) break block4;
                    exceptionToRethrow = e;
                    for (X509Certificate cert : chain) {
                        this.allAccumulatedCerts.add(cert);
                        this.newCerts.add(cert);
                    }
                }
            }
            if (exceptionToRethrow != null) {
                throw exceptionToRethrow;
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.parentTm.getAcceptedIssuers();
        }
    }
}

